from apscheduler.schedulers.asyncio import AsyncIOScheduler
from database.queries import delete_old_pending_orders

scheduler = AsyncIOScheduler()

# اضافه کردن کار زمان‌بندی شده برای حذف سفارشات معوق
scheduler.add_job(delete_old_pending_orders, 'interval', days=1)  # هر روز یکبار اجرا شود

# شروع زمان‌بند
scheduler.start()


from apscheduler.schedulers.asyncio import AsyncIOScheduler
from database.queries import delete_old_pending_orders, get_cron_enabled
from services.notification.sender import send_expiration_notifications
import asyncio

scheduler = AsyncIOScheduler()

# حذف سفارشات معوق — فعلی
scheduler.add_job(delete_old_pending_orders, 'interval', days=1)

# job اطلاع‌رسانی — مثلاً هر 30 دقیقه اجرا شود (قابل تغییر)
async def notification_job_wrapper():
    # اگر کرون خاموش است، send_expiration_notifications خودش هم چک می‌کند اما اینجا هم می‌تونیم سرسخت باشیم:
    cron_enabled = await get_cron_enabled()
    if not cron_enabled:
        return
    # اجرا
    await send_expiration_notifications(
        threshold_seconds=24*3600,    # اطلاع 24 ساعته
        throttle_seconds=1.0,
        chunk_size=50,
        chunk_pause_seconds=5.0,
        batch_limit=300
    )

# از add_job برای اجرا استفاده می‌کنیم — از func async پشتیبانی میشه ولی برای اطمینان از wrapper استفاده کردم
scheduler.add_job(lambda: asyncio.create_task(notification_job_wrapper()), 'interval', minutes=30)

scheduler.start()
