from database.queries import get_payment_config  # ← async_session را اینجا لازم نداریم

async def get_payment_info() -> str:
    """
    متن اطلاعات پرداخت کارت‌به‌کارت برای کاربر.
    نمایش شماره کارت و صاحب حساب با خط جداکننده برای وضوح بیشتر.
    """
    config = await get_payment_config()  # ← بدون پاس دادن session

    if not config or not config.card_number:
        return "⚠️ اطلاعات پرداخت هنوز تنظیم نشده است. لطفاً با پشتیبانی تماس بگیرید."

    card_number = config.card_number
    card_holder = config.card_holder or "-"

    # ساخت متن با خطوط جداکننده
    return (
        "💳 <b>مشخصات پرداخت کارت‌به‌کارت</b>\n\n"
        "• شماره کارت :\n"
        "======================\n"
        f"💳 {card_number} - bank\n"
        "======================\n"
        f"• 👤 نام صاحب حساب : {card_holder}\n"
        "\n\n"
        "• ❗ مسئولیت هرگونه واریز اشتباه به عهده‌ی کاربر است 🚨\n"
        "• ⚠️ لطفاً در واریز مبلغ دقت کنید، به دلیل مشکلات حقوقی پیش آمده "
        "به هیچ عنوان امکان بازگشت وجه وجود ندارد و تمامی مسئولیت واریز اشتباه برعهده‌ی خود شماست.\n"
        "• توجه کنید ✅مبلغ نهایی✅ تعیین شده را دقیقا و عینا واریز بفرمایید . در غیر اینصورت پرداخت شما تایید نخواهد شد . ❌\n\n"
        "👇 پس از واریز، روی دکمۀ «📤 ارسال رسید» بزنید و عکس یا متنِ رسید را ارسال کنید. 🌸"
    )
