from pathlib import Path
from datetime import datetime, timedelta

def cleanup_old_receipts(folder: str = "receipts", days: int = 60) -> int:
    """
    پاک‌سازی فایل‌های قدیمی‌تر از X روز از پوشه رسیدها
    برمی‌گرداند: تعداد فایل‌های حذف‌شده
    فولدر receipts هیچ‌وقت حذف نمی‌شود.
    """
    folder_path = Path(folder)
    folder_path.mkdir(exist_ok=True)  # اگر وجود نداشت، دوباره بساز

    cutoff = datetime.utcnow() - timedelta(days=days)
    deleted_count = 0

    print("🧹 Running weekly cleanup task...")

    for file in folder_path.iterdir():
        if file.is_file():   # فقط فایل‌ها حذف میشن
            try:
                mtime = datetime.utcfromtimestamp(file.stat().st_mtime)
                if mtime < cutoff:
                    file.unlink()
                    deleted_count += 1
                    print(f"   ⏳ Deleted old receipt: {file.name}")
            except Exception as e:
                print(f"⚠️ Could not delete {file}: {e}")

    if deleted_count > 0:
        print(f"✅ Cleanup finished. {deleted_count} file(s) removed.\n")
    else:
        print("✅ Cleanup finished. No files removed.\n")

    return deleted_count
