# bot/states/__init__.py
from aiogram.fsm.state import StatesGroup, State

# ─── استیت‌های ادمین (نمونه) ───
class AdminOrderStates(StatesGroup):
    waiting_for_new_expiration_date = State()

class AdminNotificationStates(StatesGroup):
    waiting_for_message = State()

# ─── استیت‌های خرید/پرداخت ───
class Purchase(StatesGroup):
    waiting_receipt = State()

# ─── استیت‌های کد تخفیف (یکجا و با alias برای سازگاری) ───
class DiscountStates(StatesGroup):
    # نام اصلی که بهتر است از این در هاندلرها استفاده شود:
    waiting_discount_code = State()
    waiting_discount_percent = State()

    # نام‌های جایگزین (برای سازگاری با کدهای قدیمی که
    # از waiting_for_code / waiting_for_percent استفاده کرده‌اند)
    waiting_for_code = waiting_discount_code
    waiting_for_percent = waiting_discount_percent
