# bot/middlewares/contact_check.py
from aiogram import BaseMiddleware, types
from aiogram.types import Message
from pathlib import Path
from bot.utils.user_check import is_user_verified  # 👈 منتقل شد به بالا

class ContactCheckMiddleware(BaseMiddleware):
    """
    این middleware قبل از هدایت به handler های اصلی پیام:
    - اگر پیام /start یا پیام حاوی contact باشد، عبور می‌دهد.
    - در غیر این صورت، چک می‌کند که آیا کاربر تأیید شده یا نه.
      - اگر تأیید نشده: دکمه‌ی ارسال شماره تماس نمایش داده می‌شود و ادامه متوقف می‌شود.
      - اگر تأیید شده: ادامه‌ی عادی.
    """
    
    async def __call__(self, handler, event: Message, data: dict):

        user_id = event.from_user.id
        
        # ✅ عبور کامل برای /start و contact
        if isinstance(event, Message):
            if event.text and event.text.startswith("/start"):
                return await handler(event, data)

            if event.contact:
                return await handler(event, data)


        # اگر کاربر تأیید نشده
        if not await is_user_verified(user_id):
            keyboard = types.ReplyKeyboardMarkup(
                keyboard=[
                    [types.KeyboardButton(
                        text="📞 ارسال شماره تماس",
                        request_contact=True
                    )]
                ],
                resize_keyboard=True,
                one_time_keyboard=True
            )
            await event.answer(
                "⚠️ برای ادامه‌ی استفاده از ربات، برای جلوگیری از اکانت‌های اسپم و یا ربات‌های مزاحم، ابتدا لازم است شماره تلفن خود را تایید کنید.\n"
                "📱 لطفاً دکمه‌ی زیر را برای ارسال شماره تماس فشار دهید. 👇",
                reply_markup=keyboard
            )
            return  # جلوگیری از اجرای handler اصلی

        

        # تماس تأیید شده — ادامه عادی
        return await handler(event, data)

