from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton


def subscriptions_keyboard(subscriptions):
    """
    ساخت کیبورد انتخاب اشتراک برای تمدید
    """
    buttons = []
    for sub in subscriptions:
        btn = InlineKeyboardButton(
            text=f"{sub.service_name} | اعتبار تا {sub.expiration_date}",
            callback_data=f"renew_order:{sub.id}"   # ✅ اصلاح شد (با colon)
        )
        buttons.append([btn])

    return InlineKeyboardMarkup(inline_keyboard=buttons)

def plans_keyboard(plans):
    """
    کیبورد انتخاب پلن جدید
    """
    buttons = []
    for plan in plans:
        btn = InlineKeyboardButton(
            text=f"{plan.name} | {plan.price} تومان",
            callback_data=f"renew_plan:{plan.id}"   # ✅ اصلاح شد (با colon)
        )
        buttons.append([btn])

    return InlineKeyboardMarkup(inline_keyboard=buttons)


def renew_menu():
    """
    کیبورد ساده برگشت
    """
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [InlineKeyboardButton(text="🔙 بازگشت", callback_data="back_to_menu")]
        ]
    )
