# bot/keyboards/admin_notify.py
from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton
from aiogram.utils.keyboard import InlineKeyboardBuilder

def notify_menu_keyboard(is_active: bool) -> InlineKeyboardMarkup:
    status_text = "🟢 فعال" if is_active else "🔴 غیرفعال"
    kb = InlineKeyboardBuilder()
    kb.button(text=f"⚙️ وضعیت کرون: {status_text}", callback_data="admin:toggle_cron")
    kb.button(text="🚀 اجرای دستی اطلاع‌رسانی تمدید", callback_data="admin:run_manual_notify")
    kb.button(text="🔙 بازگشت به منوی اصلی", callback_data="admin:main_menu")
    kb.adjust(1)
    return kb.as_markup()
