# bot/handlers/clearcache.py
import os
import sys
import shutil
import asyncio
from aiogram import Router, F
from aiogram.types import CallbackQuery
from config import ADMINS

router = Router()

@router.callback_query(F.data == "admin:clear_cache")
async def clear_cache(cb: CallbackQuery):
    if cb.from_user.id not in ADMINS:
        return await cb.answer("⛔️ شما دسترسی ندارید.", show_alert=True)

    await cb.answer("♻️ در حال پاکسازی کش...", show_alert=False)

    removed = 0
    for root, dirs, files in os.walk("."):
        for d in dirs:
            if d == "__pycache__":
                path = os.path.join(root, d)
                shutil.rmtree(path, ignore_errors=True)
                removed += 1

    await cb.message.edit_text(f"✅ پاکسازی کش انجام شد. ({removed} پوشه حذف شد)\n♻️ ربات ری‌استارت می‌شود...")

    await asyncio.sleep(2)
    os.execv(sys.executable, [sys.executable] + sys.argv + ["--restarted", str(cb.from_user.id)])
