"""backfill assigned_link_id (sqlite safe)

Revision ID: dba10fa3d97f
Revises: bb4f6ecc5981
Create Date: 2026-01-01 17:12:54.324289

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'dba10fa3d97f'
down_revision: Union[str, Sequence[str], None] = 'bb4f6ecc5981'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade():
    # SQLite-safe backfill
    op.execute("""
        UPDATE orders
        SET assigned_link_id = (
            SELECT lp.id
            FROM link_pool lp
            WHERE lp.url = orders.assigned_link_url
        )
        WHERE assigned_link_url IS NOT NULL
          AND assigned_link_id IS NULL;
    """)

    # performance index
    op.create_index(
        "ix_orders_assigned_link_id",
        "orders",
        ["assigned_link_id"],
        unique=False
    )


def downgrade():
    op.drop_index("ix_orders_assigned_link_id", table_name="orders")
