"""add payment_config table

Revision ID: 9220716aa5ab
Revises: 7113730efd75
Create Date: 2026-01-02 17:39:58.644210

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '9220716aa5ab'
down_revision: Union[str, Sequence[str], None] = '7113730efd75'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None

def upgrade():
    op.create_table(
        'payment_config',
        sa.Column('id', sa.Integer(), primary_key=True),
        sa.Column('card_number', sa.String(length=32), nullable=False),
        sa.Column('card_holder', sa.String(length=128), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
    )

    # ایجاد رکورد اولیه
    op.execute("""
        INSERT INTO payment_config (id, card_number, card_holder)
        VALUES (1, '6219861904806014', 'سروش بکائی')
    """)





def downgrade():
    op.drop_table('payment_config')
